<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddNewFieldsToUsers extends Migration
{
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('province', 100)->nullable()->after('mobile_number');
            $table->decimal('latitude', 10, 8)->nullable()->after('province');
            $table->decimal('longitude', 11, 8)->nullable()->after('latitude');
            $table->tinyInteger('has_used_trial')->default(0)->after('longitude');
        });
    }

    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn(['province', 'latitude', 'longitude', 'has_used_trial']);
        });
    }
}
